/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

import frc.emul.config.data.CfgItemShaderGlow;
import frc.emul.vectrex.ui.opengl.BlurShaderUtils;
import frc.emul.vectrex.ui.opengl.IJoglOverlayRenderer;
import frc.emul.vectrex.ui.opengl.IJoglShader;
import frc.emul.vectrex.ui.opengl.IJoglShaderContext;
import frc.emul.vectrex.ui.opengl.JoglContext;
import frc.emul.vectrex.ui.opengl.JoglFBO;
import frc.emul.vectrex.ui.opengl.JoglTexture;
import frc.emul.vectrex.ui.opengl.OverlayShaderUtils;
import frc.emul.vectrex.ui.opengl.shader.IShaderSource;
import frc.emul.vectrex.ui.opengl.shader.Shader;
import frc.emul.vectrex.ui.opengl.shader.ShaderException;
import frc.emul.vectrex.ui.opengl.shader.ShaderNotSupportedException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.media.opengl.ComponentEvents;
import javax.media.opengl.GL;

public class JoglListenerShaderOverlay
implements IJoglShader,
IJoglOverlayRenderer {
    private static final boolean DEBUG = true;
    private static final float FLICKERING_AMPLITUDE = 0.25f;
    private static final int BACKBUFFER_CLEARS_COUNT = 5;
    private static final long SOURCE_CHECK_INTERVALS = 1000L;
    private static long lastSourceCheckTag;
    private static final int BUFIDX_VECTORS = 0;
    private static final int BUFFERS_COUNT = 2;
    private static final int MIN_BUFFER_WIDTH = 25;
    private static final int MIN_BUFFER_HEIGHT = 32;
    private final FocusListener focusTracker = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            JoglListenerShaderOverlay.this.setBackBuffersDirty();
        }

        public void focusLost(FocusEvent focusEvent) {
            JoglListenerShaderOverlay.this.setBackBuffersDirty();
        }
    };
    private IShaderSource fragHorizSrc = new IShaderSource(){

        public String getContent() {
            return JoglListenerShaderOverlay.this.fragShaderHSrc.toString();
        }

        public String getID() {
            return "fragment/blur.horiz";
        }
    };
    private IShaderSource fragVertSrc = new IShaderSource(){

        public String getContent() {
            return JoglListenerShaderOverlay.this.fragShaderVSrc.toString();
        }

        public String getID() {
            return "fragment/blur.vert";
        }
    };
    private IShaderSource vertHorizSrc;
    private IShaderSource vertVertSrc = this.vertHorizSrc = new IShaderSource(){

        public String getContent() {
            return JoglListenerShaderOverlay.this.vertexShaderSrc.toString();
        }

        public String getID() {
            return "vertex/blur";
        }
    };
    private Shader shaderHBlur = new Shader(this.vertHorizSrc, this.fragHorizSrc);
    private Shader shaderVBlur = new Shader(this.vertVertSrc, this.fragVertSrc);
    private JoglFBO fbo = new JoglFBO();
    private JoglTexture[] buffers = new JoglTexture[0];
    private int fboBufferIdx;
    private boolean handleOverlay = true;
    private JoglTexture overlayBackBuffer = new JoglTexture();
    public boolean initialised;
    private int areaWidth;
    private int areaHeight;
    private int clearsCount;
    private ComponentEvents focusSource;
    private volatile boolean obsoleteShaders;
    private boolean shaderUpdated;
    private StringBuilder vertexShaderSrc;
    private StringBuilder fragShaderHSrc;
    private StringBuilder fragShaderVSrc;
    private IShaderSource fragOverlaySrc = new IShaderSource(){

        public String getContent() {
            return JoglListenerShaderOverlay.this.fragShaderOverlaySrc.toString();
        }

        public String getID() {
            return "fragment/overlay";
        }
    };
    private IShaderSource vertOverlaySrc = new IShaderSource(){

        public String getContent() {
            return JoglListenerShaderOverlay.this.vertShaderOverlaySrc.toString();
        }

        public String getID() {
            return "vertex/overlay";
        }
    };
    private Shader shaderOverlay = new Shader(this.vertOverlaySrc, this.fragOverlaySrc, false);
    private StringBuilder vertShaderOverlaySrc;
    private StringBuilder fragShaderOverlaySrc;

    JoglListenerShaderOverlay() {
    }

    public void shaderSettingsChanged() {
        this.obsoleteShaders = true;
    }

    public void windowSizeChanged(GL gL, IJoglShaderContext iJoglShaderContext) {
        this.setBackBuffersDirty();
    }

    public void shutdown(GL gL, IJoglShaderContext iJoglShaderContext) {
        iJoglShaderContext.getContext().setOverlayRenderer(null);
        this.updateFocusListener(null);
        this.fbo.release(gL);
        this.releaseFrameBuffers(gL);
        this.initialised = false;
    }

    public boolean renderStart(GL gL, IJoglShaderContext iJoglShaderContext) throws ShaderException {
        this.init(gL, iJoglShaderContext);
        this.updateFocusListener(iJoglShaderContext.getEventsSource());
        boolean bl = this.reshape(gL, iJoglShaderContext);
        if (JoglListenerShaderOverlay.shadersSourceChanged()) {
            this.updateOverlayShaders(gL);
        }
        boolean bl2 = this.shaderUpdated = bl || this.obsoleteShaders;
        if (this.shaderUpdated) {
            this.obsoleteShaders = false;
            this.updateShaders(gL, iJoglShaderContext.getContext().getGlowShader());
        }
        if (bl) {
            this.setBackBuffersDirty();
        }
        if (this.clearsCount > 0) {
            gL.glClear(16384);
            --this.clearsCount;
        }
        try {
            this.fboBufferIdx = 0;
            this.fbo.bind(gL);
            this.fbo.attachColorBuffer(gL, this.buffers[this.fboBufferIdx]);
            gL.glPushAttrib(2048);
            gL.glViewport(0, 0, this.areaWidth, this.areaHeight);
            gL.glClear(16384);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while during FrameBufferObject setup");
        }
        return false;
    }

    public void renderPassEntry(GL gL, IJoglShaderContext iJoglShaderContext, int n) {
    }

    public boolean renderPassExit(GL gL, IJoglShaderContext iJoglShaderContext, int n) {
        if (n > 1) {
            return false;
        }
        CfgItemShaderGlow cfgItemShaderGlow = iJoglShaderContext.getContext().getGlowShader();
        int n2 = cfgItemShaderGlow.passes;
        gL.glActiveTexture(33984);
        int n3 = 0;
        while (n3 < n2) {
            this.swapFrameBuffers(gL, false);
            this.shaderHBlur.useShader(gL);
            gL.glBegin(7);
            gL.glVertex2f(-1.0f, -1.0f);
            gL.glVertex2f(1.0f, -1.0f);
            gL.glVertex2f(1.0f, 1.0f);
            gL.glVertex2f(-1.0f, 1.0f);
            gL.glEnd();
            if (n3 + 1 < n2) {
                this.swapFrameBuffers(gL, false);
            } else {
                this.swapFrameBuffers(gL, true);
                gL.glPopAttrib();
            }
            this.shaderVBlur.useShader(gL);
            if (n3 == 0 && cfgItemShaderGlow.flickering) {
                float f = this.shaderUpdated ? 0.0f : cfgItemShaderGlow.flickeringFactor * 0.25f;
                float f2 = cfgItemShaderGlow.vGain ? cfgItemShaderGlow.vGainFactor : 1.0f;
                this.shaderVBlur.setUniform(gL, "light", f2 + f * (float)(Math.random() - 0.5));
            }
            gL.glBegin(7);
            gL.glVertex2f(-1.0f, -1.0f);
            gL.glVertex2f(1.0f, -1.0f);
            gL.glVertex2f(1.0f, 1.0f);
            gL.glVertex2f(-1.0f, 1.0f);
            gL.glEnd();
            ++n3;
        }
        Shader.useFixedProgram(gL);
        return true;
    }

    private void init(GL gL, IJoglShaderContext iJoglShaderContext) throws ShaderException {
        if (this.initialised) {
            return;
        }
        try {
            this.checkAvailability(gL);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while checking OpenGL extensions");
        }
        try {
            this.vertexShaderSrc = BlurShaderUtils.generateVertexShader(true);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while generating vectrex shader");
        }
        try {
            OverlayShaderUtils.Params params = new OverlayShaderUtils.Params();
            this.vertShaderOverlaySrc = OverlayShaderUtils.generateVertexShader();
            this.fragShaderOverlaySrc = OverlayShaderUtils.generateFragmentShader(params);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while generating vectrex shader");
        }
        try {
            this.initFrameBuffers();
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while initialising Frame Buffers Objects");
        }
        iJoglShaderContext.getContext().setOverlayRenderer(this);
        this.initialised = true;
    }

    private boolean reshape(GL gL, IJoglShaderContext iJoglShaderContext) throws ShaderException {
        int n;
        int n2;
        CfgItemShaderGlow cfgItemShaderGlow = iJoglShaderContext.getContext().getGlowShader();
        if (cfgItemShaderGlow.isBufferFixedSize) {
            n2 = cfgItemShaderGlow.bufferFixedWidth;
            n = cfgItemShaderGlow.bufferFixedHeight;
        } else {
            n2 = Math.max(25, (int)((float)iJoglShaderContext.getViewportWidth() * cfgItemShaderGlow.bufferSizeFactor));
            n = Math.max(32, (int)((float)iJoglShaderContext.getViewportHeight() * cfgItemShaderGlow.bufferSizeFactor));
        }
        if (n2 == this.areaWidth && n == this.areaHeight) {
            return false;
        }
        this.areaWidth = n2;
        this.areaHeight = n;
        try {
            this.updateFrameBuffers(gL, iJoglShaderContext, n2, n);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while updating Frame Buffer Objects");
        }
        return true;
    }

    private void updateShaders(GL gL, CfgItemShaderGlow cfgItemShaderGlow) throws ShaderException {
        try {
            Float f = Float.valueOf(cfgItemShaderGlow.hGain ? cfgItemShaderGlow.hGainFactor : 1.0f);
            Float f2 = Float.valueOf(cfgItemShaderGlow.vGain ? cfgItemShaderGlow.vGainFactor : 1.0f);
            if (cfgItemShaderGlow.flickering) {
                f2 = null;
            }
            float[] fArray = cfgItemShaderGlow.getHorizonalKernel().getHalfMatrix();
            float[] fArray2 = cfgItemShaderGlow.getVerticalKernel().getHalfMatrix();
            this.fragShaderHSrc = BlurShaderUtils.generateHorizontalFragmentShader(this.areaWidth, f, fArray, true);
            this.fragShaderVSrc = BlurShaderUtils.generateVerticalFragmentShader(this.areaHeight, f2, fArray2, true);
            this.shaderHBlur.recompileShader(gL);
            this.shaderVBlur.recompileShader(gL);
            this.shaderHBlur.useShader(gL);
            this.shaderHBlur.setUniform(gL, "texture", 0);
            this.shaderVBlur.useShader(gL);
            this.shaderVBlur.setUniform(gL, "texture", 0);
            Shader.useFixedProgram(gL);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while initializing GLOW shaders");
        }
    }

    private void updateOverlayShaders(GL gL) throws ShaderException {
        try {
            OverlayShaderUtils.Params params = new OverlayShaderUtils.Params();
            this.fragShaderOverlaySrc = OverlayShaderUtils.generateFragmentShader(params);
            this.vertShaderOverlaySrc = OverlayShaderUtils.generateVertexShader();
            this.shaderOverlay.recompileShader(gL);
        }
        catch (Exception exception) {
            JoglListenerShaderOverlay.abend(exception, "Error while initializing OVERLAY shaders");
        }
    }

    private boolean initFrameBuffers() {
        this.buffers = new JoglTexture[2];
        int n = 0;
        while (n < this.buffers.length) {
            this.buffers[n] = new JoglTexture();
            ++n;
        }
        return true;
    }

    private boolean releaseFrameBuffers(GL gL) {
        int n = 0;
        while (n < this.buffers.length) {
            this.buffers[n].release(gL);
            ++n;
        }
        if (this.overlayBackBuffer != null) {
            this.overlayBackBuffer.release(gL);
        }
        return true;
    }

    private void swapFrameBuffers(GL gL, boolean bl) {
        this.buffers[this.fboBufferIdx].bind(gL);
        this.fboBufferIdx ^= 1;
        if (bl) {
            if (this.handleOverlay) {
                this.fbo.attachColorBuffer(gL, this.overlayBackBuffer);
            } else {
                this.fbo.unbind(gL);
            }
        } else {
            this.fbo.attachColorBuffer(gL, this.buffers[this.fboBufferIdx]);
        }
    }

    private boolean updateFrameBuffers(GL gL, IJoglShaderContext iJoglShaderContext, int n, int n2) {
        int n3 = 0;
        while (n3 < this.buffers.length) {
            this.buffers[n3].setSize(n, n2);
            this.buffers[n3].update(gL);
            ++n3;
        }
        if (this.handleOverlay) {
            this.overlayBackBuffer.setSize(iJoglShaderContext.getViewportWidth(), iJoglShaderContext.getViewportHeight());
            this.overlayBackBuffer.update(gL);
        }
        this.fbo.bind(gL);
        this.fbo.attachColorBuffer(gL, this.buffers[0]);
        String string = this.fbo.validate(gL);
        this.fbo.unbind(gL);
        if (string != null) {
            System.err.println("Error while updating frame buffers to size (" + n + "," + n2 + ") : " + string);
        }
        return string == null;
    }

    public void overlayRendered(GL gL) {
    }

    public void renderOverlay(GL gL, JoglContext.CtxTexture ctxTexture, JoglContext.CtxTexture ctxTexture2) {
        try {
            this.overlayRenderingImpl(gL, ctxTexture, ctxTexture2);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void overlayRenderingImpl(GL gL, JoglContext.CtxTexture ctxTexture, JoglContext.CtxTexture ctxTexture2) throws Exception {
        if (!this.handleOverlay) {
            return;
        }
        this.fbo.unbind(gL);
        gL.glEnable(3553);
        gL.glActiveTexture(33986);
        gL.glBindTexture(3553, ctxTexture2.texture.intValue());
        gL.glActiveTexture(33985);
        gL.glBindTexture(3553, ctxTexture.texture.intValue());
        gL.glActiveTexture(33984);
        this.overlayBackBuffer.bind(gL);
        gL.glClear(16384);
        this.shaderOverlay.compileShader(gL);
        this.shaderOverlay.useShader(gL);
        this.shaderOverlay.setUniform(gL, "txBB", 0);
        this.shaderOverlay.setUniform(gL, "txOp", 2);
        this.shaderOverlay.setUniform(gL, "txTr", 1);
        gL.glDisable(3042);
        gL.glBegin(7);
        gL.glVertex2f(-1.0f, -1.0f);
        gL.glVertex2f(1.0f, -1.0f);
        gL.glVertex2f(1.0f, 1.0f);
        gL.glVertex2f(-1.0f, 1.0f);
        gL.glEnd();
        gL.glEnable(3042);
        Shader.useFixedProgram(gL);
        gL.glDisable(3553);
    }

    private final void setBackBuffersDirty() {
        this.clearsCount = 5;
    }

    private final void updateFocusListener(ComponentEvents componentEvents) {
        if (componentEvents != this.focusSource) {
            if (componentEvents != null) {
                componentEvents.addFocusListener(this.focusTracker);
            }
            if (this.focusSource != null) {
                this.focusSource.removeFocusListener(this.focusTracker);
            }
            this.focusSource = componentEvents;
        }
    }

    private final void checkAvailability(GL gL) throws ShaderNotSupportedException {
        Shader.checkShadingLanguageSupport(gL);
        JoglFBO.checkFrameBufferSupport(gL);
    }

    private static final void abend(Exception exception, String string) throws ShaderException {
        throw exception instanceof ShaderException ? (ShaderException)exception : new ShaderException(string, exception);
    }

    private static final boolean shadersSourceChanged() {
        long l = System.currentTimeMillis();
        if (l - lastSourceCheckTag < 1000L) {
            return false;
        }
        lastSourceCheckTag = l;
        return OverlayShaderUtils.sourceChanged();
    }
}

